/** @file   TankBullet.cpp
 * @brief   Implementation of TankBullet class.
 * @version $Revision: 1.3 $
 * @date    $Date: 2006/02/17 23:08:13 $
 * @author  Tomi Lamminsaari
 */

#include "TankBullet.h"
#include "www_map.h"
#include "GfxManager.h"
#include "bullettable.h"
#include "gfxid.h"
#include "GameAnims.h"
#include "AnimId.h"
#include "AnimPlayer.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
TankBullet::TankBullet( GameObject* aShooter, const Vec2D& aPos ) :
  Bullet( aShooter, Bullet::ETankBullet, aPos )
{
}



/** Destructor.
 */
TankBullet::~TankBullet()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Draws this bullet
 */
void TankBullet::redraw( BITMAP* aBitmap ) const
{
  int posX = iPosition.intX() - Map::scrollX;
  int posY = iPosition.intY() - Map::scrollY;
  RLE_SPRITE* gfx = GfxManager::findRleSprite( GfxId::KBulletCannonBall, 0 );
  posX -= gfx->w / 2;
  posY -= gfx->h / 2;
  draw_rle_sprite( aBitmap, gfx, posX, posY );
}



/** Explodes this bullet.
 */
void TankBullet::endingActions( BulletTable* aBulletTable )
{
  // First we have to undo the latest movement.
  iPosition -= iVelocity;
  
  Weapon tmpWeapon( Weapon::W_GRENADE );
  float a = 0;
  float angleStep = 256.0 / 32.0;
  for ( int i=0; i < 32; i++ ) {
    Bullet* bullet = BulletTable::createBullet( iOwner, iPosition,
                                                Bullet::EGrenade );
    Vec2D veloVec( bullet->velocity() );
    veloVec.rotate( a );
    bullet->setVelocity( veloVec );
    
    aBulletTable->spawnBullet( bullet );
    a += angleStep;
  }
  const Animation& explosionAnim = GameAnims::findAnimation( AnimId::KExplosionGrenade );
  AnimPlayer::spawn( explosionAnim, iPosition, 0 );
}

};  // end of namespace
